<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/POG_5.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/Trader.xsd" xmlns:ns5="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/POG_5A.xsd" xmlns:ns6="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/POG_5C.xsd" xmlns:ns7="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/POG_5D.xsd" version="4.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="iso-8859-1" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {	font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:text>POG-5</xsl:text> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_AKCWW" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_AKCWW"> <xsl:for-each select=" ns1:Header"> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT. UWAGI --> <xsl:apply-templates mode="Uwaga" select="."/> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:apply-templates mode="PodstawaPrawna" select="."/> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:apply-templates mode="Adres" select="."/> <!-- SZABLON DOT. ILOSCI ZALACZNIKOW --> <xsl:apply-templates mode="IleZalGry" select="."/> <!-- SZABLON DOT. PODATKU OD GRY --> <xsl:apply-templates mode="ZestawieniePodatkuGry" select="."/> <!-- SZABLON DOT. ROZLICZENIA PODATKU OD GIER --> <xsl:apply-templates mode="RozliczeniePodatkuGry" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <xsl:apply-templates mode="Adnotacje" select="."/> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> <!--ZALACZNIKI POG5A --> <xsl:for-each select=".//ns5:POG5A"> <div style="page-break-before: always"> <!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="." mode = "stopka"/></b></span> </td> </tr> </table> --> </div> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="./*"/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT. UWAGI --> <xsl:apply-templates mode="Uwaga" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika_Zal_Gry" select="."/> <!-- SZABLON DOT. DANYCH O ZEZWOLENIU --> <xsl:apply-templates mode="Zezwolenie" select="."/> <!-- SZABLON DOT. DANYCH O MONOPOLU --> <xsl:apply-templates mode="Monopol" select="."/> <!-- SZABLON DOT. OBLICZENIA PODATKU OD GIER --> <xsl:apply-templates mode="ObliczeniePodatkuGry" select="."/> </xsl:for-each> <!--ZALACZNIKI POG5C --> <xsl:for-each select=".//ns6:POG5C"> <div style="page-break-before: always"> <!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="." mode = "stopka"/></b></span> </td> </tr> </table> --> </div> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="./*"/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT. UWAGI --> <xsl:apply-templates mode="Uwaga" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika_Zal_Gry" select="."/> <!-- SZABLON DOT. DANYCH O ZEZWOLENIU --> <xsl:apply-templates mode="Zezwolenie" select="."/> <!-- SZABLON DOT. DANYCH O MONOPOLU --> <xsl:apply-templates mode="Monopol" select="."/> <!-- SZABLON DOT. DANYCH O MONOPOLU --> <xsl:apply-templates mode="Wplaty" select="."/> <!-- SZABLON DOT. OBLICZENIA PODATKU OD GIER --> <xsl:apply-templates mode="ObliczeniePodatkuGry" select="."/> </xsl:for-each> <!--ZALACZNIKI POG5D --> <xsl:for-each select=".//ns7:POG5D"> <div style="page-break-before: always"> <!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="." mode = "stopka"/></b></span> </td> </tr> </table> --> </div> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="./*"/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT. UWAGI --> <xsl:apply-templates mode="Uwaga" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika_Zal_Gry" select="."/> <!-- SZABLON DOT. DANYCH O ZEZWOLENIU --> <xsl:apply-templates mode="Zezwolenie" select="."/> <!-- SZABLON DOT. DANYCH O MONOPOLU --> <xsl:apply-templates mode="Monopol" select="."/> <!-- SZABLON DOT. OBLICZENIA PODATKU OD GIER --> <xsl:apply-templates mode="ObliczeniePodatkuGry" select="."/> </xsl:for-each> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <xsl:if test="ns1:* |ns7:*"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" height="45" valign="middle" width="586"> <span class="cz10"> <b>1. Identyfikator Podatkowy NIP/numer PESEL</b> (niepotrzebne skreślić)<b>podatnika </b> </span> </td> <td align="center" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" valign="top"> <td align="left" height="45" valign="top"> <b>Numer wlasny:</b> <span class="cz18"> <xsl:value-of select="//@selfRef"/> </span> <br/> <b>Data wypelnienia deklaracji:</b> <span class="cz18"> <xsl:value-of select="//@declarationDate"/> </span> </td> <td align="center" valign="bottom"> <xsl:if test="@refNumber">Nr referencyjny nadany przez System eZefir:<br/> <xsl:value-of select="//@refNumber"/> </xsl:if> </td> </tr> </table> </xsl:if> <xsl:if test="ns5:* | ns6:*"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" height="45" valign="middle" width="586"> <span class="cz12"> <b>1. Identyfikator Podatkowy NIP podatnika </b> </span> </td> <td align="center" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" valign="top"> <td align="left" height="45" valign="top"> <b>Numer wlasny:</b> <span class="cz18"> <xsl:value-of select="//@selfRef"/> </span> <br/> <b>Data wypelnienia deklaracji:</b> <span class="cz18"> <xsl:value-of select="//@declarationDate"/> </span> </td> <td align="center" valign="bottom"> <xsl:if test="@refNumber">Nr referencyjny nadany przez System eZefir:<br/> <xsl:value-of select="//@refNumber"/> </xsl:if> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1"> <xsl:text>POG-5</xsl:text> </span> </td> </tr> <tr> <td height="61" width="154"/> <td width="537"> <div align="center"> <span class="nag1">DEKLARACJA DLA PODATKU OD GIER <br/>za</span> <br/> <span class="nag1"/> </div> </td> <td width="243"/> </tr> </table> </xsl:if> <xsl:if test="ns5:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">POG-5/A</span> </td> </tr> <tr> <td> <div align="center"> <span class="nag1">ZAŁĄCZNIK DO DEKLARACJI DLA PODATKU OD GIER POG-5</span> <br/> <span class="nag1"> za </span> </div> </td> </tr> </table> </xsl:if> <xsl:if test="ns6:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">POG-5/C</span> </td> </tr> <tr> <td> <div align="center"> <span class="nag1">ZAŁĄCZNIK DO DEKLARACJI DLA PODATKU OD GIER POG-5</span> <br/> <span class="nag1"> za </span> </div> </td> </tr> </table> </xsl:if> <xsl:if test="ns7:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">POG-5/D</span> </td> </tr> <tr> <td> <div align="center"> <span class="nag1">ZAŁĄCZNIK DO DEKLARACJI DLA PODATKU OD GIER POG-5</span> <br/> <span class="nag1"> za </span> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:template match="*" mode="rok_mc"> <xsl:if test="ns1:*"> <table border="1" width="955"> <tr> <td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>4. Miesiąc</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>5. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,1,4)"/> </div> </td> <td width="206"/> <td align="left" valign="top" width="206"> <br/> <div align="center" class="cz18"/> </td> </tr> </table> </xsl:if> <xsl:if test="ns5:* | ns7:*"> <table border="1" width="955"> <tr> <td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>5. Miesiąc</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(.//@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>6. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(.//@period,1,4)"/> </div> </td> <td width="206"/> <td align="left" valign="top" width="206"> <b>4. Numer zalacznika 1)</b> <br/> <div align="center" class="cz18"> <xsl:value-of select=".//@formNo"/> </div> </td> </tr> </table> </xsl:if> <xsl:if test="ns6:*"> <table border="1" width="955"> <tr> <td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>4. Miesiąc</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(.//@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>5. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(.//@period,1,4)"/> </div> </td> <td width="206"/> <td align="left" valign="top" width="206"> <div align="center" class="cz18"/> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. UWAGI --> <xsl:template match="*" mode="Uwaga"> <xsl:if test="ns1:*"> <table width="955"> <tr> <td> <span class="cz12">Deklaracja jest przeznaczona dla wszystkich podatników podatku od gier z wyłączeniem podatników w pokerze rozgrywanym w formie turnieju gry pokera.  </span> </td> </tr> </table> </xsl:if> <xsl:if test="ns5:*"> <table width="955"> <tr> <td> <span class="cz12">Załącznik jest przeznaczony dla podatników podatku od gier prowadzących kasyna gry, salony gry bingo pieniężne oraz urządzających zakłady wzajemne i loterie audioteksowe.</span> </td> </tr> </table> </xsl:if> <xsl:if test="ns6:*"> <table width="955"> <tr> <td> <span class="cz12">Załącznik jest przeznaczony dla podatników podatku od gier urządzających gry objęte monopolem państwa.</span> </td> </tr> </table> </xsl:if> <xsl:if test="ns7:*"> <table width="955"> <tr> <td> <span class="cz12">Załącznik jest przeznaczony dla podatników podatku od gier urządzających grę bingo fantowe i loterię fantową, inne niż urządzane przez sieć Internet.</span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:template match="*" mode="PodstawaPrawna"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td align="left" valign="top" width="115">Podstawa prawna: </td> <td align="left" valign="top" width="824">Art. 75 ust. 1 ustawy z dnia 19 listopada 2009 r. o grach hazardowych (Dz. U. z 2016 r. poz. 471, z późn. zm.), zwanej dalej „ustawą”.</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Skladajacy:</td> <td align="left" valign="top">Podatnicy podatku od gier, zwani dalej „podatnikami”, z wyłączeniem podatników w pokerze rozgrywanym w formie turnieju gry pokera.</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Termin skladania:</td> <td align="left" valign="top">Do 10 dnia miesiąca następującego po miesiącu, którego dotyczy rozliczenie (art. 75 ust. 1 ustawy).</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Miejsce skladania: </td> <td align="left" valign="top">Naczelnik urzędu skarbowego właściwy zgodnie z art. 77 ustawy, zwany dalej „organem”.</td> </tr> </table> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <span class="nag1">A. MIEJSCE I CEL SKŁADANIA DEKLARACJI</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="46"/> <td colspan="2"> <b>6. Organ, do którego składana jest deklaracja</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="@taxOffice"/> </span> </td> </tr> <tr> <td class="style3" colspan="2"> <b>7. Cel złożenia formularza</b>(zaznaczyć właściwy kwadrat):	</td> </tr> <tr> <td align="left" valign="top" width="422">1. złożenie deklaracji<br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"> <br/> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> </xsl:if> </td> <td align="left" valign="top" width="471">2. korekta deklaracji<sup>1)</sup> <br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"> <br/> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> <br/> <xsl:value-of select="@justification"/> </xsl:if> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1">B. DANE PODATNIKA</span> <br/>* - dotyczy podmiotów niebędących osobami fizycznymi     ** - dotyczy podmiotów będących osobami fizycznymi </td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag2">B.1. DANE IDENTYFIKACYJNE</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="4" width="38"/> <td align="left" colspan="2" valign="top"> <b>8. Rodzaj podatnika </b>(zaznaczyć właściwy kwadrat): </td> </tr> <tr> <td align="left" valign="top" width="425">1. podatnik niebędący osobą fizyczna<xsl:for-each select=".//ns4:Corporate"> <b> <span class="cz14">X</span> </b> </xsl:for-each> </td> <td align="left" valign="top" width="470">2. osoba fizyczna<xsl:for-each select=".//ns4:PrivatePerson"> <b> <span class="cz14">X</span> </b> </xsl:for-each> </td> </tr> <tr> <td align="left" colspan="2" valign="top"> <b>9. Nazwa pelna */ Nazwisko, pierwsze imię, data urodzenia **</b> <br/> <br/> <xsl:for-each select=".//ns4:Corporate"> <span class="cz18"> <xsl:value-of select=".//@fullName"/> </span> </xsl:for-each> <xsl:for-each select=".//ns4:PrivatePerson"> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@firstName"/> </span> <span class="cz18"> <xsl:value-of select=".//@surname"/> </span> <span class="cz18"> <xsl:value-of select=".//@dateOfBirth"/> </span> </xsl:for-each> </td> </tr> <tr> <td> <b>10.REGON * </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@REGON"/> </span> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="Adres"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY * / ADRES ZAMIESZKANIA LUB MIEJSCA WYKONYWANIA DZIAŁALNOŚCI OBJĘTEJ ZEZWOLENIEM **</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td width="269"> <b>11. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2"> <b>12. Wojewodztwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2"> <b>13. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>14. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2"> <b>15. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> <td width="144"> <b>16. Nr domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td width="151"> <b>17. Nr lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>18. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td colspan="2" width="130"> <b>19. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> <td colspan="2" width="181"> <b>20. Poczta</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalName"/> </span> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. ILOSCI ZALACZNIKOW --> <xsl:template match="*" mode="IleZalGry"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">C. INFORMACJE O ZAŁĄCZNIKACH</span> <br/>W poz.21-23 nalezy podać liczbę dołączonych załączników.</td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="2" width="36"/> <td align="center" bgcolor="#CCCCCC" valign="middle" width="236"> <span class="cz18"> <b>POG-5/A</b> </span> </td> <td align="center" bgcolor="#CCCCCC" valign="middle" width="304"> <span class="cz18"> <b>POG-5/C</b> </span> </td> <td align="center" bgcolor="#CCCCCC" valign="middle" width="351"> <span class="cz18"> <b>POG-5/D</b> </span> </td> </tr> <tr> <td align="left" valign="top"> <b>21.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="count(.//ns5:POG5A)"/> </div> </td> <td align="left" valign="top"> <b>22.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="count(.//ns6:POG5C)"/> </div> </td> <td align="left" valign="top"> <b>23.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="count(.//ns7:POG5D)"/> </div> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"> <xsl:apply-templates mode="stopka" select="../.."/> </span> <sub style="cz9">(2)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. PODATKU OD GRY --> <xsl:template match="*" mode="ZestawieniePodatkuGry"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1">D. ZESTAWIENIE PODATKU OD GIER</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="6" width="45"/> <td align="center" bgcolor="#CCCCCC" valign="top" width="497"> <span class="cz14"> <b>Załącznik </b> </span> </td> <td align="center" bgcolor="#CCCCCC" valign="top" width="391"> <span class="cz14"> <b>Zbiorcze zestawienie podatku</b> <br/> </span> <div align="right" class="cz10">zł</div> </td> </tr> <tr> <td align="left" valign="top"> <b>POG-5/A</b> <br/> <br/> <br/>Należy wpisać sumę kwot podatku z poz.54 poszczególnych załącznikow</td> <td align="left" valign="top"> <b>24.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//@amountPog5a"/> </div> </td> </tr> <tr> <td align="left" valign="top"> <b>POG-5/C</b> <br/> <br/> <br/>Należy wpisać kwotę podatku z poz.53 załącznika</td> <td align="left" valign="top"> <b>25.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//@amountPog5c"/> </div> </td> </tr> <tr> <td align="left" valign="top"> <b>POG-5/D</b> <br/> <br/> <br/>Należy wpisać sumę kwot podatku z poz.18 poszczególnych załączników</td> <td align="left" valign="top"> <b>26.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//@amountPog5d"/> </div> </td> </tr> <tr> <td align="left" valign="top"> <b>Razem </b> <br/> <br/> <br/>Suma kwot z poz. od 24 do 26.</td> <td align="left" bordercolor="#000000" valign="top"> <b>27.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//@totalExciseDuties"/> </div> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. ROZLICZENIA PODATKU OD GIER --> <xsl:template match="*" mode="RozliczeniePodatkuGry"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1"> <b>E. ROZLICZENIE PODATKU OD GIER</b> </span> <br/> <div align="right" class="cz10">zł</div> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="4" width="40"/> <td width="596"> <b>Nadpłata wpłat dziennych za poprzedni okres rozliczeniowy</b> <br/> <br/>Kwota z poz. 31 deklaracji złożonej za poprzedni okres lub wynikająca z decyzji</td> <td align="left" valign="top" width="297"> <b>28.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="//@excessContributSettlementOfPrevDecl"/> </div> </td> </tr> <tr> <td> <b>Wpłaty dzienne podatku od gier liczbowych dokonane za okres, którego dotyczy deklaracja</b>(tylko dla załącznika POG-5/C) <br/> <br/>Należy wpisać kwotę z poz. 10 załącznika POG-5/C</td> <td align="left" valign="top"> <b>29.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="//@amountOfPaymentsDaily"/> </div> </td> </tr> <tr> <td> <b>Podatek do zapłaty</b> <br/> <br/>Od kwoty z poz. 27 należy odjąć sumę kwot z poz. 28 i 29. Jeżeli różnica jest liczbą ujemną, należy wpisać 0</td> <td align="left" valign="top"> <b>30.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="//@toPay"/> </div> </td> </tr> <tr> <td> <b>Nadwyżka wpłat dziennych do rozliczania w następnym okresie rozliczeniowym</b> <br/> <br/>Od sumy kwoty z poz.28 i 29 należy odjąć kwotę z poz.27. Jeżeli różnica jest liczbą ujemną, należy wpisac 0.</td> <td align="left" valign="top"> <b>31.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="//@excessContributSettlement"/> </div> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1">F. PODPIS PODATNIKA LUB PEŁNOMOCNIKA</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="45"/> <td align="left" valign="top" width="417"> <b>32. Nazwisko</b> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname"/> </span> </td> <td align="left" valign="top" width="471"> <b>33. Imię</b> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> </tr> <tr> <td align="left" valign="top"> <b>34. Telefon kontaktowy</b> (pole nieobowiązkowe) <br/> <span class="cz18"> <xsl:value-of select="//@phone"/> </span> </td> <td align="left" valign="top"> <b>35. Adres email (pole nieobowiązkowe)</b> <br/> <span class="cz18"> <xsl:value-of select="ns1:Statement/ns3:representative/@email"/> </span> </td> </tr> <tr> <td align="left" valign="top"> <b>36. Data sporządzenia deklaracji</b>(dzień - miesiąc - rok) <br/> <span class="cz18"> <xsl:value-of select="//@declarationDate"/> </span> </td> <td align="left" valign="top"> <b>37. Podpis podatnika lub pełnomocnika</b> <br/> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <xsl:if test="ns1:*"> <table border="1" height="167" width="955"> <tr bgcolor="#CCCCCC"> <td class="nag1" colspan="3" height="36">G. ADNOTACJE ORGANU</td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>38. Uwagi organu <br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td height="49" width="472"> <b>39. Identyfikator przyjmującego formularz <br/> <br/> <br/> </b> <p/> </td> <td width="421"> <b>40. Podpis przyjmującego formularz</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:template match="*" mode="ObjasnieniaAkc"> <xsl:if test="ns1:*"> <table width="955"> <tr> <td> <p align="center"> <b>Objaśnienie</b> </p> <p> <sup>1)</sup>Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2017 r. poz. 201, z późn. zm).</p> <p align="center"> <b>Pouczenie:</b> <b/> </p> <p>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz. 30 lub wpłacenia jej w niepełnej wysokości niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2016 r. poz. 599, z późn. zm.). Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</p> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">POG-5</span> <sub style="cz9">(2)</sub> <b style="nag1">/2</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM --> <xsl:template match="*" mode="NowaStrona_Zal"> <!-- tymczasowo --> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"> <!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="." mode = "stopka"/></b></span> </td> </tr> </table> --> </div> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA W ZALACZNIKACH--> <xsl:template match="*" mode="DanePodatnika_Zal_Gry"> <xsl:if test="ns5:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC"> <td colspan="2"> <span class="nag1">A. DANE IDENTYFIKACYJNE PODATNIKA</span> </td> </tr> <tr align="left"> <td bgcolor="#CCCCCC" rowspan="2" width="46"/> <td align="left" valign="top" width="893"> <b>7. Nazwa pełna</b> <br/> <span class="cz18"> <xsl:value-of select=".//@fullName"/> </span> <span class="cz18"> <xsl:value-of select=".//@firstName"/> </span> <span class="cz18"> <xsl:value-of select=".//@surname"/> </span> <span class="cz18"> <xsl:value-of select=".//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select=".//@PESEL"/> </span> </td> </tr> <tr> <td align="left" class="style3" valign="top"> <b>8. REGON</b> <br/> <span class="cz18"> <xsl:value-of select="//@Regon"/> </span> </td> </tr> </table> </xsl:if> <xsl:if test="ns6:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC"> <td colspan="2"> <span class="nag1">A. DANE IDENTYFIKACYJNE PODATNIKA</span> </td> </tr> <tr align="left"> <td bgcolor="#CCCCCC" rowspan="2" width="46"/> <td align="left" valign="top" width="893"> <b>6. Nazwa pełna</b> <br/> <span class="cz18"> <xsl:value-of select=".//@fullName"/> </span> <span class="cz18"> <xsl:value-of select=".//@firstName"/> </span> <span class="cz18"> <xsl:value-of select=".//@surname"/> </span> <span class="cz18"> <xsl:value-of select=".//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select=".//@PESEL"/> </span> </td> </tr> <tr> <td align="left" class="style3" valign="top"> <b>7. REGON</b> <br/> <span class="cz18"> <xsl:value-of select="//@Regon"/> </span> </td> </tr> </table> </xsl:if> <xsl:if test="ns7:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC"> <td colspan="2"> <span class="nag1">A. DANE IDENTYFIKACYJNE PODATNIKA</span> <br/>* - dotyczy podmiotów niebędących osobami fizycznymi     ** - dotyczy podmiotów będących osobami fizycznymi </td> </tr> <tr align="left"> <td bgcolor="#CCCCCC" rowspan="2" width="46"/> <td align="left" valign="top" width="893"> <b>7. Nazwa pełna * / Nazwisko, pierwsze imię, data urodzenia **</b> <br/> <span class="cz18"> <xsl:value-of select=".//@fullName"/> </span> <span class="cz18"> <xsl:value-of select=".//@firstName"/> </span> <span class="cz18"> <xsl:value-of select=".//@surname"/> </span> <span class="cz18"> <xsl:value-of select=".//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select=".//@PESEL"/> </span> </td> </tr> <tr> <td align="left" class="style3" valign="top"> <b>8. REGON *</b> <br/> <span class="cz18"> <xsl:value-of select=".//@regon"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH O ZEZWOLENIU --> <xsl:template match="ns5:*" mode="Zezwolenie"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1">B. DANE O ZEZWOLENIU/KONCESJI </span> <br/>W przypadku gdy w ramach właściwości miejscowej jednego naczelnika urzędu skarbowego podatnik posiada więcej niż jedno zezwolenie/koncesję, podatnik powinien złożyć tyle załączników, ile zezwoleń/koncesji posiada.</td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="2" width="40"/> <td align="left" valign="top" width="449"> <b>9. Numer zezwolenia/koncesji </b> <br/> <br/> <div align="left" class="cz18" valign="top"> <xsl:value-of select=".//ns5:Concession/@numberOfConcession"/> </div> </td> <td align="left" valign="top" width="444"> <b>10. Data wydania zezwolenia/koncesji</b> (dzień - miesiąc - rok) <br/> <br/> <div align="center" class="cz18" valign="top"> <xsl:value-of select=".//ns5:Concession/@licenseIssueDate"/> </div> </td> </tr> <tr> <td align="left" colspan="2" valign="top"> <b>11. Organ wydający zezwolenie/koncesję</b> <br/> <div align="left" class="cz18" valign="top"> <xsl:value-of select=".//ns5:Concession/@licensingAuthority"/> </div> </td> </tr> </table> </xsl:template> <xsl:template match="*" mode="Zezwolenie"> <xsl:if test="ns7:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1">B. DANE O ZEZWOLENIU</span> <br/>W przypadku gdy w ramach właściwości miejscowej jednego naczelnika urzędu skarbowego podatnik posiada więcej niż jedno zezwolenie, podatnik powinien złożyć tyle załączników, ile zezwoleń posiada.</td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="2" width="40"/> <td align="left" valign="top" width="449"> <b>9. Numer zezwolenia</b> <br/> <br/> <div align="left" class="cz18" valign="top"> <xsl:value-of select=".//ns7:Concession/@numberOfConcession"/> </div> </td> <td align="left" valign="top" width="444"> <b>10. Data wydania zezwolenia </b> (dzień - miesiąc - rok) <br/> <br/> <div align="center" class="cz18" valign="top"> <xsl:value-of select=".//ns7:Concession/@licenseIssueDate"/> </div> </td> </tr> <tr> <td align="left" colspan="2" valign="top"> <b>11. Organ wydajacy zezwolenie</b> <br/> <div align="left" class="cz18" valign="top"> <xsl:value-of select=".//ns7:Concession/@licensingAuthority"/> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH O MONOPOLU --> <xsl:template match="*" mode="Monopol"> <xsl:if test="ns6:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1">B. DANE O REALIZACJI MONOPOLU PANSTWA</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" width="42"/> <td align="left" valign="top" width="548"> <b>8. Dane o utworzeniu jednoosobowej spółki Skarbu Państwa - art. 5 ust. 2 ustawy</b> <br/> <div align="left" class="cz18" valign="top"> <xsl:value-of select="..//@data"/> </div> </td> <td align="left" valign="top" width="343"> <b>9. Data utworzenia </b>(dzień-miesiąc-rok) <br/> <br/> <div align="center" class="cz18" valign="bottom"> <xsl:value-of select="..//@creationDate"/> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. wpłat dziennych --> <xsl:template match="*" mode="Wplaty"> <xsl:if test="ns1:* | ns6:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1">C. WYSOKOŚĆ WPŁAT DZIENNYCH PODATKU OD GIER LICZBOWYCH</span> <div align="right" class="10">zł</div> </td> </tr> <tr> <td bgcolor="#CCCCCC" width="42"/> <td align="left" bgcolor="#CCCCCC" valign="top" width="548"> <b>Wpłaty dzienne podatku od gier liczbowych dokonane za okres, którego dotyczy deklaracja </b> <p> Kwotę tę należy przenieść do poz. 29 deklaracji POG-5 </p> </td> <td align="left" valign="top" width="343"> <b>10. </b> <br/> <br/> <div align="center" class="cz18" valign="bottom"> <xsl:value-of select="//@amountOfPaymentsDaily"/> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBLICZENIA PODATKU OD GIER --> <xsl:template match="*" mode="ObliczeniePodatkuGry"> <xsl:if test="ns5:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag1">C. OBLICZENIE WYSOKOŚCI PODATKU OD GIER</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="col" width="35"/> <td bgcolor="#CCCCCC" colspan="2" scope="col"> <div align="center" class="cz12"> <b>Rodzaje gry hazardowej </b> </div> </td> <td bgcolor="#CCCCCC" scope="col" width="154"> <div align="center" class="cz12"> <b>Podstawa<br/>opodatkowania</b> </div> </td> <td bgcolor="#CCCCCC" scope="col" width="127"> <div align="center" class="cz12"> <b>Stawka podatku</b> </div> </td> <td bgcolor="#CCCCCC" scope="col" width="150"> <div align="center" class="cz12"> <b>Wysokość podatku </b> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.1 </th> <td bgcolor="#CCCCCC" rowspan="4" width="74"> <b>Kasyna gry<sup>2)</sup> </b> </td> <td bgcolor="#CCCCCC" width="265"> <b>Gry cylindryczne w kasynie</b> </td> <td> <b>12.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='21']/@tax"/> </div> </td> <td> <b>13.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='21']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='21']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>14.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='21']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.2 </th> <td bgcolor="#CCCCCC"> <b>Gry na automatach w kasynie </b> </td> <td> <b>15.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='22']/@tax"/> </div> </td> <td> <b>16.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='22']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='22']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>17.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='22']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.3 </th> <td bgcolor="#CCCCCC"> <b>Gry w karty z wyłączeniem pokera rozgrywanego w formie turnieju gry pokera</b> </td> <td> <b>18.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='23']/@tax"/> </div> </td> <td> <b>19.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='23']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='23']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>20.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='23']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.4 </th> <td bgcolor="#CCCCCC"> <b>Gra w kości</b> </td> <td> <b>21.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='24']/@tax"/> </div> </td> <td> <b>22.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='24']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='24']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>23.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='24']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.5 </th> <td bgcolor="#CCCCCC"> <b>Salony gry bingo pieniężne</b> </td> <td bgcolor="#CCCCCC"> <b>Gra bingo pieniężne </b> </td> <td> <b>24.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='25']/@tax"/> </div> </td> <td> <b>25.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='25']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='25']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>26.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='25']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.6 </th> <td bgcolor="#CCCCCC" rowspan="8"> <b>Zakłady wzajemne </b> </td> <td align="left" bgcolor="#CCCCCC"> <b>Odgadywanie wyników współzawodnictwa ludzi<br/>– zakłady urządzane w punktach przyjmowania zakładów wzajemnych</b> </td> <td> <b>27.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='26']/@tax"/> </div> </td> <td> <b>28.</b> <br/> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='26']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='26']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>29.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='26']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.7 </th> <td align="left" bgcolor="#CCCCCC"> <b>Odgadywanie wyników współzawodnictwa ludzi<br/>- zakłady urządzane przez sieć Internet </b> </td> <td> <b>30.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='27']/@tax"/> </div> </td> <td> <b>31.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='27']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='27']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>32.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='27']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.8 </th> <td align="left" bgcolor="#CCCCCC"> <b>Odgadywanie wyników współzawodnictwa zwierząt<br/>– zakłady urządzane w punktach przyjmowania zakładów wzajemnych</b> </td> <td> <b>33.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='28']/@tax"/> </div> </td> <td> <b>34.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='28']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='28']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>35.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='28']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.9 </th> <td align="left" bgcolor="#CCCCCC"> <b>Odgadywanie wyników współzawodnictwa zwierząt<br/>- zakłady urządzane przez sieć Internet</b> </td> <td> <b>36.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='29']/@tax"/> </div> </td> <td> <b>37.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='29']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='29']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>38.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='29']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.10 </th> <td align="left" bgcolor="#CCCCCC"> <b>Zdarzenia wirtualne<br/>– zakłady urządzane w punktach przyjmowania zakładów wzajemnych</b> </td> <td> <b>39.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='30']/@tax"/> </div> </td> <td> <b>40.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='30']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='30']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>41.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='30']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.11 </th> <td align="left" bgcolor="#CCCCCC"> <b>Zdarzenia wirtualne<br/>- zakłady urządzane przez sieć Internet </b> </td> <td> <b>42.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='31']/@tax"/> </div> </td> <td> <b>43.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='31']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='31']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>44.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='31']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.12 </th> <td align="left" bgcolor="#CCCCCC"> <b>Pozostałe rodzaje zakładów wzajemnych<br/>– zakłady urządzane w punktach<br>przyjmownia zakładów wzajemnych</br> </b> </td> <td> <b>45.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='32']/@tax"/> </div> </td> <td> <b>46.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='32']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='32']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>47.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='32']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.13 </th> <td align="left" bgcolor="#CCCCCC"> <b>Pozostałe rodzaje zakładów wzajemnych<br/>- zakłady urządzane przez sieć Internet </b> </td> <td> <b>48.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='33']/@tax"/> </div> </td> <td> <b>49.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='33']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='33']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>50.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='33']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"> C.14 </th> <td bgcolor="#CCCCCC" colspan="2"> <b>Loterie audioteksowe</b> </td> <td> <b>51.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='34']/@tax"/> </div> </td> <td> <b>52.</b> <xsl:if test=".//ns5:CalculationOfTaxOnGame[@typeOfGame='34']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='34']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>53.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns5:CalculationOfTaxOnGame[@typeOfGame='34']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"/> <td bgcolor="#CCCCCC" colspan="4"> <b> <span class="cz12">Razem</span> </b> <br/>Suma kwot podatku z wierszy od C.1 do C.14. Kwotę tę należy przenieść do poz. 24 deklaracji POG-5 </td> <td> <b>54.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//@totalOfTax"/> </div> </td> </tr> </table> <table width="955"> <tr> <td> <sup>1)</sup>Należy podać kolejny numer załącznika.<br/> <sup>2)</sup>W przypadku gdy suma wypłaconych lub uzyskanych wygranych jest wyższa niż suma wpłaconych stawek, w kolumnie Podstawa opodatkowania należy wpisać 0.<br/> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"> POG-5/A </span> <sub style="cz9">(2)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:if> <xsl:if test="ns6:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag1">D. OBLICZENIE WYSOKOŚCI PODATKU OD GIER</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="col" width="35"/> <td bgcolor="#CCCCCC" colspan="2" scope="col"> <div align="center" class="cz12"> <b>Rodzaje gry hazardowej </b> </div> </td> <td bgcolor="#CCCCCC" scope="col" width="154"> <div align="center" class="cz12"> <b>Podstawa<br/>opodatkowania</b> </div> </td> <td bgcolor="#CCCCCC" scope="col" width="127"> <div align="center" class="cz12"> <b>Stawka podatku</b> </div> </td> <td bgcolor="#CCCCCC" scope="col" width="150"> <div align="center" class="cz12"> <b>Wysokość podatku </b> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row">D.1</td> <td bgcolor="#CCCCCC" rowspan="4" width="74"> <b>Gry inne niż<br/>urządzane przez sieć Internet</b> </td> <td bgcolor="#CCCCCC" width="265"> <b>Gry liczbowe</b> </td> <td> <b>11.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='35']/@tax"/> </div> </td> <td> <b>12.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='35']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='35']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>13.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='35']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.2 </td> <td bgcolor="#CCCCCC"> <b>Loterie pieniężne </b> </td> <td> <b>14.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='36']/@tax"/> </div> </td> <td> <b>15.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='36']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='36']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>16.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='36']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.3 </td> <td bgcolor="#CCCCCC"> <b>Gra telebingo </b> </td> <td> <b>17.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='51']/@tax"/> </div> </td> <td> <b>18.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='51']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='51']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>19.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='51']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.4 </td> <td bgcolor="#CCCCCC"> <b>Gry na automatach<br/>(w salonach gier)<sup>1)</sup> </b> </td> <td> <b>20.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='37']/@tax"/> </div> </td> <td> <b>21.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='37']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='37']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>22.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='37']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.5 </td> <td bgcolor="#CCCCCC" rowspan="10"> <b>Gry urządzane<br/>przez sieć Internet</b> </td> <td bgcolor="#CCCCCC"> <b>Gry liczbowe</b> </td> <td> <b>23.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='38']/@tax"/> </div> </td> <td> <b>24.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='38']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='38']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>25.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='38']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.6 </td> <td bgcolor="#CCCCCC"> <b>Loterie pieniężne</b> </td> <td> <b>26.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='39']/@tax"/> </div> </td> <td> <b>27.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='39']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='39']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>28.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='39']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.7 </td> <td bgcolor="#CCCCCC"> <b>Gra telebingo</b> </td> <td> <b>29.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='40']/@tax"/> </div> </td> <td> <b>30.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='40']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='40']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>31.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='40']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.8 </td> <td bgcolor="#CCCCCC"> <b>Gry cylindryczne <sup>1)</sup> </b> </td> <td> <b>32.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='41']/@tax"/> </div> </td> <td> <b>33.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='41']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='41']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>34.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='41']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.9 </td> <td bgcolor="#CCCCCC"> <b>Gry odpowiadające zasadom gier na automatach<sup>1)</sup> </b> </td> <td> <b>35.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='42']/@tax"/> </div> </td> <td> <b>36.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='42']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='42']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>37.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='42']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.10 </td> <td bgcolor="#CCCCCC"> <b>Gry w karty <sup>1)</sup> </b> </td> <td> <b>38.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='43']/@tax"/> </div> </td> <td> <b>39.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='43']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='43']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>40.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='43']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.11 </td> <td bgcolor="#CCCCCC"> <b>Gra w kości <sup>1)</sup> </b> </td> <td> <b>41.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='44']/@tax"/> </div> </td> <td> <b>42.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='44']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='44']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>43.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='44']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.12 </td> <td bgcolor="#CCCCCC"> <b>Gra bingo pieniężne</b> </td> <td> <b>44.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='45']/@tax"/> </div> </td> <td> <b>45.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='45']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='45']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>46.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='45']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.13 </td> <td bgcolor="#CCCCCC"> <b>Loterie fantowe</b> </td> <td> <b>47.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='46']/@tax"/> </div> </td> <td> <b>48.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='46']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='46']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>49.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='46']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"> D.14 </td> <td bgcolor="#CCCCCC"> <b>Gra bingo fantowe</b> </td> <td> <b>50.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='47']/@tax"/> </div> </td> <td> <b>51.</b> <xsl:if test=".//ns6:CalculationOfTaxOnGame[@typeOfGame='47']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='47']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>52.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns6:CalculationOfTaxOnGame[@typeOfGame='47']/@amountOfTax"/> </div> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="row"/> <td bgcolor="#CCCCCC" colspan="4"> <b> <span class="cz12">Razem</span> </b> <br/>Suma kwot podatku z wierszy od D.1 do D.14. Kwotę tę należy przenieść do poz. 25 deklaracji POG-5</td> <td> <b>53.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//@totalAmountOfTax"/> </div> </td> </tr> </table> <table width="955"> <tr> <td> <sup>1)</sup>W przypadku gdy suma wypłaconych lub uzyskanych wygranych jest wyższa niż suma wpłaconych stawek, w kolumnie Podstawa opodatkowania należy wpisać 0.<br/> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"> POG-5/C </span> <sub style="cz9">(2)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:if> <xsl:if test="ns7:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag1">C. OBLICZENIE WYSOKOŚCI PODATKU OD GIER</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" scope="col" width="35"/> <td bgcolor="#CCCCCC" colspan="2" scope="col"> <div align="center" class="cz12"> <b>Rodzaje gry hazardowej </b> </div> </td> <td bgcolor="#CCCCCC" scope="col" width="154"> <div align="center" class="cz12"> <b>Podstawa<br/>opodatkowania</b> </div> </td> <td bgcolor="#CCCCCC" scope="col" width="127"> <div align="center" class="cz12"> <b>Stawka podatku</b> </div> </td> <td bgcolor="#CCCCCC" scope="col" width="150"> <div align="center" class="cz12"> <b>Wysokość podatku </b> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"/> <td bgcolor="#CCCCCC" colspan="2" width="265"> <span class="cz12"> <b>Gra bingo fantowe</b> </span> </td> <td> <b>12.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns7:CalculationOfTaxOnGame[@typeOfGame='48']/@tax"/> </div> </td> <td> <b>13.</b> <xsl:if test=".//ns7:CalculationOfTaxOnGame[@typeOfGame='48']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns7:CalculationOfTaxOnGame[@typeOfGame='48']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>14.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns7:CalculationOfTaxOnGame[@typeOfGame='48']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"/> <td bgcolor="#CCCCCC" colspan="2"> <span class="cz12"> <b>Loteria fantowa</b> </span> </td> <td> <b>15.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns7:CalculationOfTaxOnGame[@typeOfGame='49']/@tax"/> </div> </td> <td> <b>16.</b> <xsl:if test=".//ns7:CalculationOfTaxOnGame[@typeOfGame='49']/@taxRatePercentage"> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns7:CalculationOfTaxOnGame[@typeOfGame='49']/@taxRatePercentage * 100"/>% </div> </xsl:if> </td> <td> <b>17.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns7:CalculationOfTaxOnGame[@typeOfGame='49']/@amountOfTax"/> </div> </td> </tr> <tr> <th bgcolor="#CCCCCC" scope="row"/> <td bgcolor="#CCCCCC" colspan="4"> <b> <span class="cz12">Razem</span> </b> <br/> Suma kwot z poz. 14 i 17. <br/>Kwotę z poz. 18 należy przenieść do poz. 26 deklaracji POG-5 </td> <td> <b>18.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//@totalAmountOfTax"/> </div> </td> </tr> </table> <table width="955"> <tr> <td> <sup>1)</sup>Należy podać kolejny numer załącznika.<br/> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"> POG-5/D </span> <sub style="cz9">(2)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet>